/********************************************************************************
	Copyright (C) 2012 PaulusT

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*********************************************************************************/
#pragma pack(1)
#include "stdafx.h"

#define CALLCONV __stdcall

HINSTANCE hLThis = 0;
HINSTANCE hL = 0;
FARPROC p[193] = {0};

void LoadDlls()
{
  WIN32_FIND_DATAW dat;
  HANDLE file = INVALID_HANDLE_VALUE;
  WCHAR buff[MAX_PATH] = {0};
  
  //Find first file
  file=FindFirstFileW(L"plugins\\*.dll",&dat);
  
  while(true)
  {
    if(file == INVALID_HANDLE_VALUE)
      break;
    
    //Add filename to "plugins\..."
    std::wstring path = std::wstring(L"plugins\\") + dat.cFileName;

    //Get the full path (into buff)
    DWORD gfpr = GetFullPathNameW(path.c_str(),MAX_PATH,buff,NULL);

    if(gfpr <= MAX_PATH && gfpr != 0)
    {
      LoadLibraryW((LPWSTR)buff);
    }

    ZeroMemory(&dat,sizeof(dat));
    ZeroMemory(buff,sizeof(buff));

    BOOL res = FindNextFileW(file,&dat);
    if(res == 0)
    {
      break;
    }
  }

  //Close the find handle
  FindClose(file);
}

BOOL WINAPI DllMain(HINSTANCE hInst,DWORD reason,LPVOID)
{
  if (reason == DLL_PROCESS_ATTACH)
  {
    hLThis = hInst;
    std::vector<WCHAR> winmm;
    winmm.resize(MAX_PATH);
    UINT res = GetSystemDirectoryW(&winmm[0],MAX_PATH);
    if(res == 0) return false;
    std::wstring winmm2 = &winmm[0] + std::wstring(L"\\winmm.dll\0");
    hL = LoadLibraryW(winmm2.c_str());
    p[0] = GetProcAddress(hL,"CloseDriver");
    p[1] = GetProcAddress(hL,"DefDriverProc");
    p[2] = GetProcAddress(hL,"DriverCallback");
    p[3] = GetProcAddress(hL,"DrvGetModuleHandle");
    p[4] = GetProcAddress(hL,"GetDriverModuleHandle");
    p[5] = GetProcAddress(hL,"NotifyCallbackData");
    p[6] = GetProcAddress(hL,"OpenDriver");
    p[7] = GetProcAddress(hL,"PlaySound");
    p[8] = GetProcAddress(hL,"PlaySoundA");
    p[9] = GetProcAddress(hL,"PlaySoundW");
    p[10] = GetProcAddress(hL,"SendDriverMessage");
    p[11] = GetProcAddress(hL,"WOW32DriverCallback");
    p[12] = GetProcAddress(hL,"WOW32ResolveMultiMediaHandle");
    p[13] = GetProcAddress(hL,"WOWAppExit");
    p[14] = GetProcAddress(hL,"aux32Message");
    p[15] = GetProcAddress(hL,"auxGetDevCapsA");
    p[16] = GetProcAddress(hL,"auxGetDevCapsW");
    p[17] = GetProcAddress(hL,"auxGetNumDevs");
    p[18] = GetProcAddress(hL,"auxGetVolume");
    p[19] = GetProcAddress(hL,"auxOutMessage");
    p[20] = GetProcAddress(hL,"auxSetVolume");
    p[21] = GetProcAddress(hL,"joy32Message");
    p[22] = GetProcAddress(hL,"joyConfigChanged");
    p[23] = GetProcAddress(hL,"joyGetDevCapsA");
    p[24] = GetProcAddress(hL,"joyGetDevCapsW");
    p[25] = GetProcAddress(hL,"joyGetNumDevs");
    p[26] = GetProcAddress(hL,"joyGetPos");
    p[27] = GetProcAddress(hL,"joyGetPosEx");
    p[28] = GetProcAddress(hL,"joyGetThreshold");
    p[29] = GetProcAddress(hL,"joyReleaseCapture");
    p[30] = GetProcAddress(hL,"joySetCapture");
    p[31] = GetProcAddress(hL,"joySetThreshold");
    p[32] = GetProcAddress(hL,"mci32Message");
    p[33] = GetProcAddress(hL,"mciDriverNotify");
    p[34] = GetProcAddress(hL,"mciDriverYield");
    p[35] = GetProcAddress(hL,"mciExecute");
    p[36] = GetProcAddress(hL,"mciFreeCommandResource");
    p[37] = GetProcAddress(hL,"mciGetCreatorTask");
    p[38] = GetProcAddress(hL,"mciGetDeviceIDA");
    p[39] = GetProcAddress(hL,"mciGetDeviceIDFromElementIDA");
    p[40] = GetProcAddress(hL,"mciGetDeviceIDFromElementIDW");
    p[41] = GetProcAddress(hL,"mciGetDeviceIDW");
    p[42] = GetProcAddress(hL,"mciGetDriverData");
    p[43] = GetProcAddress(hL,"mciGetErrorStringA");
    p[44] = GetProcAddress(hL,"mciGetErrorStringW");
    p[45] = GetProcAddress(hL,"mciGetYieldProc");
    p[46] = GetProcAddress(hL,"mciLoadCommandResource");
    p[47] = GetProcAddress(hL,"mciSendCommandA");
    p[48] = GetProcAddress(hL,"mciSendCommandW");
    p[49] = GetProcAddress(hL,"mciSendStringA");
    p[50] = GetProcAddress(hL,"mciSendStringW");
    p[51] = GetProcAddress(hL,"mciSetDriverData");
    p[52] = GetProcAddress(hL,"mciSetYieldProc");
    p[53] = GetProcAddress(hL,"mid32Message");
    p[54] = GetProcAddress(hL,"midiConnect");
    p[55] = GetProcAddress(hL,"midiDisconnect");
    p[56] = GetProcAddress(hL,"midiInAddBuffer");
    p[57] = GetProcAddress(hL,"midiInClose");
    p[58] = GetProcAddress(hL,"midiInGetDevCapsA");
    p[59] = GetProcAddress(hL,"midiInGetDevCapsW");
    p[60] = GetProcAddress(hL,"midiInGetErrorTextA");
    p[61] = GetProcAddress(hL,"midiInGetErrorTextW");
    p[62] = GetProcAddress(hL,"midiInGetID");
    p[63] = GetProcAddress(hL,"midiInGetNumDevs");
    p[64] = GetProcAddress(hL,"midiInMessage");
    p[65] = GetProcAddress(hL,"midiInOpen");
    p[66] = GetProcAddress(hL,"midiInPrepareHeader");
    p[67] = GetProcAddress(hL,"midiInReset");
    p[68] = GetProcAddress(hL,"midiInStart");
    p[69] = GetProcAddress(hL,"midiInStop");
    p[70] = GetProcAddress(hL,"midiInUnprepareHeader");
    p[71] = GetProcAddress(hL,"midiOutCacheDrumPatches");
    p[72] = GetProcAddress(hL,"midiOutCachePatches");
    p[73] = GetProcAddress(hL,"midiOutClose");
    p[74] = GetProcAddress(hL,"midiOutGetDevCapsA");
    p[75] = GetProcAddress(hL,"midiOutGetDevCapsW");
    p[76] = GetProcAddress(hL,"midiOutGetErrorTextA");
    p[77] = GetProcAddress(hL,"midiOutGetErrorTextW");
    p[78] = GetProcAddress(hL,"midiOutGetID");
    p[79] = GetProcAddress(hL,"midiOutGetNumDevs");
    p[80] = GetProcAddress(hL,"midiOutGetVolume");
    p[81] = GetProcAddress(hL,"midiOutLongMsg");
    p[82] = GetProcAddress(hL,"midiOutMessage");
    p[83] = GetProcAddress(hL,"midiOutOpen");
    p[84] = GetProcAddress(hL,"midiOutPrepareHeader");
    p[85] = GetProcAddress(hL,"midiOutReset");
    p[86] = GetProcAddress(hL,"midiOutSetVolume");
    p[87] = GetProcAddress(hL,"midiOutShortMsg");
    p[88] = GetProcAddress(hL,"midiOutUnprepareHeader");
    p[89] = GetProcAddress(hL,"midiStreamClose");
    p[90] = GetProcAddress(hL,"midiStreamOpen");
    p[91] = GetProcAddress(hL,"midiStreamOut");
    p[92] = GetProcAddress(hL,"midiStreamPause");
    p[93] = GetProcAddress(hL,"midiStreamPosition");
    p[94] = GetProcAddress(hL,"midiStreamProperty");
    p[95] = GetProcAddress(hL,"midiStreamRestart");
    p[96] = GetProcAddress(hL,"midiStreamStop");
    p[97] = GetProcAddress(hL,"mixerClose");
    p[98] = GetProcAddress(hL,"mixerGetControlDetailsA");
    p[99] = GetProcAddress(hL,"mixerGetControlDetailsW");
    p[100] = GetProcAddress(hL,"mixerGetDevCapsA");
    p[101] = GetProcAddress(hL,"mixerGetDevCapsW");
    p[102] = GetProcAddress(hL,"mixerGetID");
    p[103] = GetProcAddress(hL,"mixerGetLineControlsA");
    p[104] = GetProcAddress(hL,"mixerGetLineControlsW");
    p[105] = GetProcAddress(hL,"mixerGetLineInfoA");
    p[106] = GetProcAddress(hL,"mixerGetLineInfoW");
    p[107] = GetProcAddress(hL,"mixerGetNumDevs");
    p[108] = GetProcAddress(hL,"mixerMessage");
    p[109] = GetProcAddress(hL,"mixerOpen");
    p[110] = GetProcAddress(hL,"mixerSetControlDetails");
    p[111] = GetProcAddress(hL,"mmDrvInstall");
    p[112] = GetProcAddress(hL,"mmGetCurrentTask");
    p[113] = GetProcAddress(hL,"mmTaskBlock");
    p[114] = GetProcAddress(hL,"mmTaskCreate");
    p[115] = GetProcAddress(hL,"mmTaskSignal");
    p[116] = GetProcAddress(hL,"mmTaskYield");
    p[117] = GetProcAddress(hL,"mmioAdvance");
    p[118] = GetProcAddress(hL,"mmioAscend");
    p[119] = GetProcAddress(hL,"mmioClose");
    p[120] = GetProcAddress(hL,"mmioCreateChunk");
    p[121] = GetProcAddress(hL,"mmioDescend");
    p[122] = GetProcAddress(hL,"mmioFlush");
    p[123] = GetProcAddress(hL,"mmioGetInfo");
    p[124] = GetProcAddress(hL,"mmioInstallIOProcA");
    p[125] = GetProcAddress(hL,"mmioInstallIOProcW");
    p[126] = GetProcAddress(hL,"mmioOpenA");
    p[127] = GetProcAddress(hL,"mmioOpenW");
    p[128] = GetProcAddress(hL,"mmioRead");
    p[129] = GetProcAddress(hL,"mmioRenameA");
    p[130] = GetProcAddress(hL,"mmioRenameW");
    p[131] = GetProcAddress(hL,"mmioSeek");
    p[132] = GetProcAddress(hL,"mmioSendMessage");
    p[133] = GetProcAddress(hL,"mmioSetBuffer");
    p[134] = GetProcAddress(hL,"mmioSetInfo");
    p[135] = GetProcAddress(hL,"mmioStringToFOURCCA");
    p[136] = GetProcAddress(hL,"mmioStringToFOURCCW");
    p[137] = GetProcAddress(hL,"mmioWrite");
    p[138] = GetProcAddress(hL,"mmsystemGetVersion");
    p[139] = GetProcAddress(hL,"mod32Message");
    p[140] = GetProcAddress(hL,"mxd32Message");
    p[141] = GetProcAddress(hL,"sndPlaySoundA");
    p[142] = GetProcAddress(hL,"sndPlaySoundW");
    p[143] = GetProcAddress(hL,"tid32Message");
    p[144] = GetProcAddress(hL,"timeBeginPeriod");
    p[145] = GetProcAddress(hL,"timeEndPeriod");
    p[146] = GetProcAddress(hL,"timeGetDevCaps");
    p[147] = GetProcAddress(hL,"timeGetSystemTime");
    p[148] = GetProcAddress(hL,"timeGetTime");
    p[149] = GetProcAddress(hL,"timeKillEvent");
    p[150] = GetProcAddress(hL,"timeSetEvent");
    p[151] = GetProcAddress(hL,"waveInAddBuffer");
    p[152] = GetProcAddress(hL,"waveInClose");
    p[153] = GetProcAddress(hL,"waveInGetDevCapsA");
    p[154] = GetProcAddress(hL,"waveInGetDevCapsW");
    p[155] = GetProcAddress(hL,"waveInGetErrorTextA");
    p[156] = GetProcAddress(hL,"waveInGetErrorTextW");
    p[157] = GetProcAddress(hL,"waveInGetID");
    p[158] = GetProcAddress(hL,"waveInGetNumDevs");
    p[159] = GetProcAddress(hL,"waveInGetPosition");
    p[160] = GetProcAddress(hL,"waveInMessage");
    p[161] = GetProcAddress(hL,"waveInOpen");
    p[162] = GetProcAddress(hL,"waveInPrepareHeader");
    p[163] = GetProcAddress(hL,"waveInReset");
    p[164] = GetProcAddress(hL,"waveInStart");
    p[165] = GetProcAddress(hL,"waveInStop");
    p[166] = GetProcAddress(hL,"waveInUnprepareHeader");
    p[167] = GetProcAddress(hL,"waveOutBreakLoop");
    p[168] = GetProcAddress(hL,"waveOutClose");
    p[169] = GetProcAddress(hL,"waveOutGetDevCapsA");
    p[170] = GetProcAddress(hL,"waveOutGetDevCapsW");
    p[171] = GetProcAddress(hL,"waveOutGetErrorTextA");
    p[172] = GetProcAddress(hL,"waveOutGetErrorTextW");
    p[173] = GetProcAddress(hL,"waveOutGetID");
    p[174] = GetProcAddress(hL,"waveOutGetNumDevs");
    p[175] = GetProcAddress(hL,"waveOutGetPitch");
    p[176] = GetProcAddress(hL,"waveOutGetPlaybackRate");
    p[177] = GetProcAddress(hL,"waveOutGetPosition");
    p[178] = GetProcAddress(hL,"waveOutGetVolume");
    p[179] = GetProcAddress(hL,"waveOutMessage");
    p[180] = GetProcAddress(hL,"waveOutOpen");
    p[181] = GetProcAddress(hL,"waveOutPause");
    p[182] = GetProcAddress(hL,"waveOutPrepareHeader");
    p[183] = GetProcAddress(hL,"waveOutReset");
    p[184] = GetProcAddress(hL,"waveOutRestart");
    p[185] = GetProcAddress(hL,"waveOutSetPitch");
    p[186] = GetProcAddress(hL,"waveOutSetPlaybackRate");
    p[187] = GetProcAddress(hL,"waveOutSetVolume");
    p[188] = GetProcAddress(hL,"waveOutUnprepareHeader");
    p[189] = GetProcAddress(hL,"waveOutWrite");
    p[190] = GetProcAddress(hL,"wid32Message");
    p[191] = GetProcAddress(hL,"wod32Message");
    p[192] = GetProcAddress(hL,(LPCSTR)"2");

    LoadDlls();

  }
  if (reason == DLL_PROCESS_DETACH)
  {
    FreeLibrary(hL);
  }

  return 1;
}

// CloseDriver
extern "C" __declspec(naked) void CALLCONV __E__0__()
{
  __asm
  {
    jmp p[0*4];
  }
}

// DefDriverProc
extern "C" __declspec(naked) void CALLCONV __E__1__()
{
  __asm
  {
    jmp p[1*4];
  }
}

// DriverCallback
extern "C" __declspec(naked) void CALLCONV __E__2__()
{
  __asm
  {
    jmp p[2*4];
  }
}

// DrvGetModuleHandle
extern "C" __declspec(naked) void CALLCONV __E__3__()
{
  __asm
  {
    jmp p[3*4];
  }
}

// GetDriverModuleHandle
extern "C" __declspec(naked) void CALLCONV __E__4__()
{
  __asm
  {
    jmp p[4*4];
  }
}

// NotifyCallbackData
extern "C" __declspec(naked) void CALLCONV __E__5__()
{
  __asm
  {
    jmp p[5*4];
  }
}

// OpenDriver
extern "C" __declspec(naked) void CALLCONV __E__6__()
{
  __asm
  {
    jmp p[6*4];
  }
}

// PlaySound
extern "C" __declspec(naked) void CALLCONV __E__7__()
{
  __asm
  {
    jmp p[7*4];
  }
}

// PlaySoundA
extern "C" __declspec(naked) void CALLCONV __E__8__()
{
  __asm
  {
    jmp p[8*4];
  }
}

// PlaySoundW
extern "C" __declspec(naked) void CALLCONV __E__9__()
{
  __asm
  {
    jmp p[9*4];
  }
}

// SendDriverMessage
extern "C" __declspec(naked) void CALLCONV __E__10__()
{
  __asm
  {
    jmp p[10*4];
  }
}

// WOW32DriverCallback
extern "C" __declspec(naked) void CALLCONV __E__11__()
{
  __asm
  {
    jmp p[11*4];
  }
}

// WOW32ResolveMultiMediaHandle
extern "C" __declspec(naked) void CALLCONV __E__12__()
{
  __asm
  {
    jmp p[12*4];
  }
}

// WOWAppExit
extern "C" __declspec(naked) void CALLCONV __E__13__()
{
  __asm
  {
    jmp p[13*4];
  }
}

// aux32Message
extern "C" __declspec(naked) void CALLCONV __E__14__()
{
  __asm
  {
    jmp p[14*4];
  }
}

// auxGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__15__()
{
  __asm
  {
    jmp p[15*4];
  }
}

// auxGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__16__()
{
  __asm
  {
    jmp p[16*4];
  }
}

// auxGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__17__()
{
  __asm
  {
    jmp p[17*4];
  }
}

// auxGetVolume
extern "C" __declspec(naked) void CALLCONV __E__18__()
{
  __asm
  {
    jmp p[18*4];
  }
}

// auxOutMessage
extern "C" __declspec(naked) void CALLCONV __E__19__()
{
  __asm
  {
    jmp p[19*4];
  }
}

// auxSetVolume
extern "C" __declspec(naked) void CALLCONV __E__20__()
{
  __asm
  {
    jmp p[20*4];
  }
}

// joy32Message
extern "C" __declspec(naked) void CALLCONV __E__21__()
{
  __asm
  {
    jmp p[21*4];
  }
}

// joyConfigChanged
extern "C" __declspec(naked) void CALLCONV __E__22__()
{
  __asm
  {
    jmp p[22*4];
  }
}

// joyGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__23__()
{
  __asm
  {
    jmp p[23*4];
  }
}

// joyGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__24__()
{
  __asm
  {
    jmp p[24*4];
  }
}

// joyGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__25__()
{
  __asm
  {
    jmp p[25*4];
  }
}

// joyGetPos
extern "C" __declspec(naked) void CALLCONV __E__26__()
{
  __asm
  {
    jmp p[26*4];
  }
}

// joyGetPosEx
extern "C" __declspec(naked) void CALLCONV __E__27__()
{
  __asm
  {
    jmp p[27*4];
  }
}

// joyGetThreshold
extern "C" __declspec(naked) void CALLCONV __E__28__()
{
  __asm
  {
    jmp p[28*4];
  }
}

// joyReleaseCapture
extern "C" __declspec(naked) void CALLCONV __E__29__()
{
  __asm
  {
    jmp p[29*4];
  }
}

// joySetCapture
extern "C" __declspec(naked) void CALLCONV __E__30__()
{
  __asm
  {
    jmp p[30*4];
  }
}

// joySetThreshold
extern "C" __declspec(naked) void CALLCONV __E__31__()
{
  __asm
  {
    jmp p[31*4];
  }
}

// mci32Message
extern "C" __declspec(naked) void CALLCONV __E__32__()
{
  __asm
  {
    jmp p[32*4];
  }
}

// mciDriverNotify
extern "C" __declspec(naked) void CALLCONV __E__33__()
{
  __asm
  {
    jmp p[33*4];
  }
}

// mciDriverYield
extern "C" __declspec(naked) void CALLCONV __E__34__()
{
  __asm
  {
    jmp p[34*4];
  }
}

// mciExecute
extern "C" __declspec(naked) void CALLCONV __E__35__()
{
  __asm
  {
    jmp p[35*4];
  }
}

// mciFreeCommandResource
extern "C" __declspec(naked) void CALLCONV __E__36__()
{
  __asm
  {
    jmp p[36*4];
  }
}

// mciGetCreatorTask
extern "C" __declspec(naked) void CALLCONV __E__37__()
{
  __asm
  {
    jmp p[37*4];
  }
}

// mciGetDeviceIDA
extern "C" __declspec(naked) void CALLCONV __E__38__()
{
  __asm
  {
    jmp p[38*4];
  }
}

// mciGetDeviceIDFromElementIDA
extern "C" __declspec(naked) void CALLCONV __E__39__()
{
  __asm
  {
    jmp p[39*4];
  }
}

// mciGetDeviceIDFromElementIDW
extern "C" __declspec(naked) void CALLCONV __E__40__()
{
  __asm
  {
    jmp p[40*4];
  }
}

// mciGetDeviceIDW
extern "C" __declspec(naked) void CALLCONV __E__41__()
{
  __asm
  {
    jmp p[41*4];
  }
}

// mciGetDriverData
extern "C" __declspec(naked) void CALLCONV __E__42__()
{
  __asm
  {
    jmp p[42*4];
  }
}

// mciGetErrorStringA
extern "C" __declspec(naked) void CALLCONV __E__43__()
{
  __asm
  {
    jmp p[43*4];
  }
}

// mciGetErrorStringW
extern "C" __declspec(naked) void CALLCONV __E__44__()
{
  __asm
  {
    jmp p[44*4];
  }
}

// mciGetYieldProc
extern "C" __declspec(naked) void CALLCONV __E__45__()
{
  __asm
  {
    jmp p[45*4];
  }
}

// mciLoadCommandResource
extern "C" __declspec(naked) void CALLCONV __E__46__()
{
  __asm
  {
    jmp p[46*4];
  }
}

// mciSendCommandA
extern "C" __declspec(naked) void CALLCONV __E__47__()
{
  __asm
  {
    jmp p[47*4];
  }
}

// mciSendCommandW
extern "C" __declspec(naked) void CALLCONV __E__48__()
{
  __asm
  {
    jmp p[48*4];
  }
}

// mciSendStringA
extern "C" __declspec(naked) void CALLCONV __E__49__()
{
  __asm
  {
    jmp p[49*4];
  }
}

// mciSendStringW
extern "C" __declspec(naked) void CALLCONV __E__50__()
{
  __asm
  {
    jmp p[50*4];
  }
}

// mciSetDriverData
extern "C" __declspec(naked) void CALLCONV __E__51__()
{
  __asm
  {
    jmp p[51*4];
  }
}

// mciSetYieldProc
extern "C" __declspec(naked) void CALLCONV __E__52__()
{
  __asm
  {
    jmp p[52*4];
  }
}

// mid32Message
extern "C" __declspec(naked) void CALLCONV __E__53__()
{
  __asm
  {
    jmp p[53*4];
  }
}

// midiConnect
extern "C" __declspec(naked) void CALLCONV __E__54__()
{
  __asm
  {
    jmp p[54*4];
  }
}

// midiDisconnect
extern "C" __declspec(naked) void CALLCONV __E__55__()
{
  __asm
  {
    jmp p[55*4];
  }
}

// midiInAddBuffer
extern "C" __declspec(naked) void CALLCONV __E__56__()
{
  __asm
  {
    jmp p[56*4];
  }
}

// midiInClose
extern "C" __declspec(naked) void CALLCONV __E__57__()
{
  __asm
  {
    jmp p[57*4];
  }
}

// midiInGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__58__()
{
  __asm
  {
    jmp p[58*4];
  }
}

// midiInGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__59__()
{
  __asm
  {
    jmp p[59*4];
  }
}

// midiInGetErrorTextA
extern "C" __declspec(naked) void CALLCONV __E__60__()
{
  __asm
  {
    jmp p[60*4];
  }
}

// midiInGetErrorTextW
extern "C" __declspec(naked) void CALLCONV __E__61__()
{
  __asm
  {
    jmp p[61*4];
  }
}

// midiInGetID
extern "C" __declspec(naked) void CALLCONV __E__62__()
{
  __asm
  {
    jmp p[62*4];
  }
}

// midiInGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__63__()
{
  __asm
  {
    jmp p[63*4];
  }
}

// midiInMessage
extern "C" __declspec(naked) void CALLCONV __E__64__()
{
  __asm
  {
    jmp p[64*4];
  }
}

// midiInOpen
extern "C" __declspec(naked) void CALLCONV __E__65__()
{
  __asm
  {
    jmp p[65*4];
  }
}

// midiInPrepareHeader
extern "C" __declspec(naked) void CALLCONV __E__66__()
{
  __asm
  {
    jmp p[66*4];
  }
}

// midiInReset
extern "C" __declspec(naked) void CALLCONV __E__67__()
{
  __asm
  {
    jmp p[67*4];
  }
}

// midiInStart
extern "C" __declspec(naked) void CALLCONV __E__68__()
{
  __asm
  {
    jmp p[68*4];
  }
}

// midiInStop
extern "C" __declspec(naked) void CALLCONV __E__69__()
{
  __asm
  {
    jmp p[69*4];
  }
}

// midiInUnprepareHeader
extern "C" __declspec(naked) void CALLCONV __E__70__()
{
  __asm
  {
    jmp p[70*4];
  }
}

// midiOutCacheDrumPatches
extern "C" __declspec(naked) void CALLCONV __E__71__()
{
  __asm
  {
    jmp p[71*4];
  }
}

// midiOutCachePatches
extern "C" __declspec(naked) void CALLCONV __E__72__()
{
  __asm
  {
    jmp p[72*4];
  }
}

// midiOutClose
extern "C" __declspec(naked) void CALLCONV __E__73__()
{
  __asm
  {
    jmp p[73*4];
  }
}

// midiOutGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__74__()
{
  __asm
  {
    jmp p[74*4];
  }
}

// midiOutGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__75__()
{
  __asm
  {
    jmp p[75*4];
  }
}

// midiOutGetErrorTextA
extern "C" __declspec(naked) void CALLCONV __E__76__()
{
  __asm
  {
    jmp p[76*4];
  }
}

// midiOutGetErrorTextW
extern "C" __declspec(naked) void CALLCONV __E__77__()
{
  __asm
  {
    jmp p[77*4];
  }
}

// midiOutGetID
extern "C" __declspec(naked) void CALLCONV __E__78__()
{
  __asm
  {
    jmp p[78*4];
  }
}

// midiOutGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__79__()
{
  __asm
  {
    jmp p[79*4];
  }
}

// midiOutGetVolume
extern "C" __declspec(naked) void CALLCONV __E__80__()
{
  __asm
  {
    jmp p[80*4];
  }
}

// midiOutLongMsg
extern "C" __declspec(naked) void CALLCONV __E__81__()
{
  __asm
  {
    jmp p[81*4];
  }
}

// midiOutMessage
extern "C" __declspec(naked) void CALLCONV __E__82__()
{
  __asm
  {
    jmp p[82*4];
  }
}

// midiOutOpen
extern "C" __declspec(naked) void CALLCONV __E__83__()
{
  __asm
  {
    jmp p[83*4];
  }
}

// midiOutPrepareHeader
extern "C" __declspec(naked) void CALLCONV __E__84__()
{
  __asm
  {
    jmp p[84*4];
  }
}

// midiOutReset
extern "C" __declspec(naked) void CALLCONV __E__85__()
{
  __asm
  {
    jmp p[85*4];
  }
}

// midiOutSetVolume
extern "C" __declspec(naked) void CALLCONV __E__86__()
{
  __asm
  {
    jmp p[86*4];
  }
}

// midiOutShortMsg
extern "C" __declspec(naked) void CALLCONV __E__87__()
{
  __asm
  {
    jmp p[87*4];
  }
}

// midiOutUnprepareHeader
extern "C" __declspec(naked) void CALLCONV __E__88__()
{
  __asm
  {
    jmp p[88*4];
  }
}

// midiStreamClose
extern "C" __declspec(naked) void CALLCONV __E__89__()
{
  __asm
  {
    jmp p[89*4];
  }
}

// midiStreamOpen
extern "C" __declspec(naked) void CALLCONV __E__90__()
{
  __asm
  {
    jmp p[90*4];
  }
}

// midiStreamOut
extern "C" __declspec(naked) void CALLCONV __E__91__()
{
  __asm
  {
    jmp p[91*4];
  }
}

// midiStreamPause
extern "C" __declspec(naked) void CALLCONV __E__92__()
{
  __asm
  {
    jmp p[92*4];
  }
}

// midiStreamPosition
extern "C" __declspec(naked) void CALLCONV __E__93__()
{
  __asm
  {
    jmp p[93*4];
  }
}

// midiStreamProperty
extern "C" __declspec(naked) void CALLCONV __E__94__()
{
  __asm
  {
    jmp p[94*4];
  }
}

// midiStreamRestart
extern "C" __declspec(naked) void CALLCONV __E__95__()
{
  __asm
  {
    jmp p[95*4];
  }
}

// midiStreamStop
extern "C" __declspec(naked) void CALLCONV __E__96__()
{
  __asm
  {
    jmp p[96*4];
  }
}

// mixerClose
extern "C" __declspec(naked) void CALLCONV __E__97__()
{
  __asm
  {
    jmp p[97*4];
  }
}

// mixerGetControlDetailsA
extern "C" __declspec(naked) void CALLCONV __E__98__()
{
  __asm
  {
    jmp p[98*4];
  }
}

// mixerGetControlDetailsW
extern "C" __declspec(naked) void CALLCONV __E__99__()
{
  __asm
  {
    jmp p[99*4];
  }
}

// mixerGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__100__()
{
  __asm
  {
    jmp p[100*4];
  }
}

// mixerGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__101__()
{
  __asm
  {
    jmp p[101*4];
  }
}

// mixerGetID
extern "C" __declspec(naked) void CALLCONV __E__102__()
{
  __asm
  {
    jmp p[102*4];
  }
}

// mixerGetLineControlsA
extern "C" __declspec(naked) void CALLCONV __E__103__()
{
  __asm
  {
    jmp p[103*4];
  }
}

// mixerGetLineControlsW
extern "C" __declspec(naked) void CALLCONV __E__104__()
{
  __asm
  {
    jmp p[104*4];
  }
}

// mixerGetLineInfoA
extern "C" __declspec(naked) void CALLCONV __E__105__()
{
  __asm
  {
    jmp p[105*4];
  }
}

// mixerGetLineInfoW
extern "C" __declspec(naked) void CALLCONV __E__106__()
{
  __asm
  {
    jmp p[106*4];
  }
}

// mixerGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__107__()
{
  __asm
  {
    jmp p[107*4];
  }
}

// mixerMessage
extern "C" __declspec(naked) void CALLCONV __E__108__()
{
  __asm
  {
    jmp p[108*4];
  }
}

// mixerOpen
extern "C" __declspec(naked) void CALLCONV __E__109__()
{
  __asm
  {
    jmp p[109*4];
  }
}

// mixerSetControlDetails
extern "C" __declspec(naked) void CALLCONV __E__110__()
{
  __asm
  {
    jmp p[110*4];
  }
}

// mmDrvInstall
extern "C" __declspec(naked) void CALLCONV __E__111__()
{
  __asm
  {
    jmp p[111*4];
  }
}

// mmGetCurrentTask
extern "C" __declspec(naked) void CALLCONV __E__112__()
{
  __asm
  {
    jmp p[112*4];
  }
}

// mmTaskBlock
extern "C" __declspec(naked) void CALLCONV __E__113__()
{
  __asm
  {
    jmp p[113*4];
  }
}

// mmTaskCreate
extern "C" __declspec(naked) void CALLCONV __E__114__()
{
  __asm
  {
    jmp p[114*4];
  }
}

// mmTaskSignal
extern "C" __declspec(naked) void CALLCONV __E__115__()
{
  __asm
  {
    jmp p[115*4];
  }
}

// mmTaskYield
extern "C" __declspec(naked) void CALLCONV __E__116__()
{
  __asm
  {
    jmp p[116*4];
  }
}

// mmioAdvance
extern "C" __declspec(naked) void CALLCONV __E__117__()
{
  __asm
  {
    jmp p[117*4];
  }
}

// mmioAscend
extern "C" __declspec(naked) void CALLCONV __E__118__()
{
  __asm
  {
    jmp p[118*4];
  }
}

// mmioClose
extern "C" __declspec(naked) void CALLCONV __E__119__()
{
  __asm
  {
    jmp p[119*4];
  }
}

// mmioCreateChunk
extern "C" __declspec(naked) void CALLCONV __E__120__()
{
  __asm
  {
    jmp p[120*4];
  }
}

// mmioDescend
extern "C" __declspec(naked) void CALLCONV __E__121__()
{
  __asm
  {
    jmp p[121*4];
  }
}

// mmioFlush
extern "C" __declspec(naked) void CALLCONV __E__122__()
{
  __asm
  {
    jmp p[122*4];
  }
}

// mmioGetInfo
extern "C" __declspec(naked) void CALLCONV __E__123__()
{
  __asm
  {
    jmp p[123*4];
  }
}

// mmioInstallIOProcA
extern "C" __declspec(naked) void CALLCONV __E__124__()
{
  __asm
  {
    jmp p[124*4];
  }
}

// mmioInstallIOProcW
extern "C" __declspec(naked) void CALLCONV __E__125__()
{
  __asm
  {
    jmp p[125*4];
  }
}

// mmioOpenA
extern "C" __declspec(naked) void CALLCONV __E__126__()
{
  __asm
  {
    jmp p[126*4];
  }
}

// mmioOpenW
extern "C" __declspec(naked) void CALLCONV __E__127__()
{
  __asm
  {
    jmp p[127*4];
  }
}

// mmioRead
extern "C" __declspec(naked) void CALLCONV __E__128__()
{
  __asm
  {
    jmp p[128*4];
  }
}

// mmioRenameA
extern "C" __declspec(naked) void CALLCONV __E__129__()
{
  __asm
  {
    jmp p[129*4];
  }
}

// mmioRenameW
extern "C" __declspec(naked) void CALLCONV __E__130__()
{
  __asm
  {
    jmp p[130*4];
  }
}

// mmioSeek
extern "C" __declspec(naked) void CALLCONV __E__131__()
{
  __asm
  {
    jmp p[131*4];
  }
}

// mmioSendMessage
extern "C" __declspec(naked) void CALLCONV __E__132__()
{
  __asm
  {
    jmp p[132*4];
  }
}

// mmioSetBuffer
extern "C" __declspec(naked) void CALLCONV __E__133__()
{
  __asm
  {
    jmp p[133*4];
  }
}

// mmioSetInfo
extern "C" __declspec(naked) void CALLCONV __E__134__()
{
  __asm
  {
    jmp p[134*4];
  }
}

// mmioStringToFOURCCA
extern "C" __declspec(naked) void CALLCONV __E__135__()
{
  __asm
  {
    jmp p[135*4];
  }
}

// mmioStringToFOURCCW
extern "C" __declspec(naked) void CALLCONV __E__136__()
{
  __asm
  {
    jmp p[136*4];
  }
}

// mmioWrite
extern "C" __declspec(naked) void CALLCONV __E__137__()
{
  __asm
  {
    jmp p[137*4];
  }
}

// mmsystemGetVersion
extern "C" __declspec(naked) void CALLCONV __E__138__()
{
  __asm
  {
    jmp p[138*4];
  }
}

// mod32Message
extern "C" __declspec(naked) void CALLCONV __E__139__()
{
  __asm
  {
    jmp p[139*4];
  }
}

// mxd32Message
extern "C" __declspec(naked) void CALLCONV __E__140__()
{
  __asm
  {
    jmp p[140*4];
  }
}

// sndPlaySoundA
extern "C" __declspec(naked) void CALLCONV __E__141__()
{
  __asm
  {
    jmp p[141*4];
  }
}

// sndPlaySoundW
extern "C" __declspec(naked) void CALLCONV __E__142__()
{
  __asm
  {
    jmp p[142*4];
  }
}

// tid32Message
extern "C" __declspec(naked) void CALLCONV __E__143__()
{
  __asm
  {
    jmp p[143*4];
  }
}

// timeBeginPeriod
extern "C" __declspec(naked) void CALLCONV __E__144__()
{
  __asm
  {
    jmp p[144*4];
  }
}

// timeEndPeriod
extern "C" __declspec(naked) void CALLCONV __E__145__()
{
  __asm
  {
    jmp p[145*4];
  }
}

// timeGetDevCaps
extern "C" __declspec(naked) void CALLCONV __E__146__()
{
  __asm
  {
    jmp p[146*4];
  }
}

// timeGetSystemTime
extern "C" __declspec(naked) void CALLCONV __E__147__()
{
  __asm
  {
    jmp p[147*4];
  }
}

// timeGetTime
extern "C" __declspec(naked) void CALLCONV __E__148__()
{
  __asm
  {
    jmp p[148*4];
  }
}

// timeKillEvent
extern "C" __declspec(naked) void CALLCONV __E__149__()
{
  __asm
  {
    jmp p[149*4];
  }
}

// timeSetEvent
extern "C" __declspec(naked) void CALLCONV __E__150__()
{
  __asm
  {
    jmp p[150*4];
  }
}

// waveInAddBuffer
extern "C" __declspec(naked) void CALLCONV __E__151__()
{
  __asm
  {
    jmp p[151*4];
  }
}

// waveInClose
extern "C" __declspec(naked) void CALLCONV __E__152__()
{
  __asm
  {
    jmp p[152*4];
  }
}

// waveInGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__153__()
{
  __asm
  {
    jmp p[153*4];
  }
}

// waveInGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__154__()
{
  __asm
  {
    jmp p[154*4];
  }
}

// waveInGetErrorTextA
extern "C" __declspec(naked) void CALLCONV __E__155__()
{
  __asm
  {
    jmp p[155*4];
  }
}

// waveInGetErrorTextW
extern "C" __declspec(naked) void CALLCONV __E__156__()
{
  __asm
  {
    jmp p[156*4];
  }
}

// waveInGetID
extern "C" __declspec(naked) void CALLCONV __E__157__()
{
  __asm
  {
    jmp p[157*4];
  }
}

// waveInGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__158__()
{
  __asm
  {
    jmp p[158*4];
  }
}

// waveInGetPosition
extern "C" __declspec(naked) void CALLCONV __E__159__()
{
  __asm
  {
    jmp p[159*4];
  }
}

// waveInMessage
extern "C" __declspec(naked) void CALLCONV __E__160__()
{
  __asm
  {
    jmp p[160*4];
  }
}

// waveInOpen
extern "C" __declspec(naked) void CALLCONV __E__161__()
{
  __asm
  {
    jmp p[161*4];
  }
}

// waveInPrepareHeader
extern "C" __declspec(naked) void CALLCONV __E__162__()
{
  __asm
  {
    jmp p[162*4];
  }
}

// waveInReset
extern "C" __declspec(naked) void CALLCONV __E__163__()
{
  __asm
  {
    jmp p[163*4];
  }
}

// waveInStart
extern "C" __declspec(naked) void CALLCONV __E__164__()
{
  __asm
  {
    jmp p[164*4];
  }
}

// waveInStop
extern "C" __declspec(naked) void CALLCONV __E__165__()
{
  __asm
  {
    jmp p[165*4];
  }
}

// waveInUnprepareHeader
extern "C" __declspec(naked) void CALLCONV __E__166__()
{
  __asm
  {
    jmp p[166*4];
  }
}

// waveOutBreakLoop
extern "C" __declspec(naked) void CALLCONV __E__167__()
{
  __asm
  {
    jmp p[167*4];
  }
}

// waveOutClose
extern "C" __declspec(naked) void CALLCONV __E__168__()
{
  __asm
  {
    jmp p[168*4];
  }
}

// waveOutGetDevCapsA
extern "C" __declspec(naked) void CALLCONV __E__169__()
{
  __asm
  {
    jmp p[169*4];
  }
}

// waveOutGetDevCapsW
extern "C" __declspec(naked) void CALLCONV __E__170__()
{
  __asm
  {
    jmp p[170*4];
  }
}

// waveOutGetErrorTextA
extern "C" __declspec(naked) void CALLCONV __E__171__()
{
  __asm
  {
    jmp p[171*4];
  }
}

// waveOutGetErrorTextW
extern "C" __declspec(naked) void CALLCONV __E__172__()
{
  __asm
  {
    jmp p[172*4];
  }
}

// waveOutGetID
extern "C" __declspec(naked) void CALLCONV __E__173__()
{
  __asm
  {
    jmp p[173*4];
  }
}

// waveOutGetNumDevs
extern "C" __declspec(naked) void CALLCONV __E__174__()
{
  __asm
  {
    jmp p[174*4];
  }
}

// waveOutGetPitch
extern "C" __declspec(naked) void CALLCONV __E__175__()
{
  __asm
  {
    jmp p[175*4];
  }
}

// waveOutGetPlaybackRate
extern "C" __declspec(naked) void CALLCONV __E__176__()
{
  __asm
  {
    jmp p[176*4];
  }
}

// waveOutGetPosition
extern "C" __declspec(naked) void CALLCONV __E__177__()
{
  __asm
  {
    jmp p[177*4];
  }
}

// waveOutGetVolume
extern "C" __declspec(naked) void CALLCONV __E__178__()
{
  __asm
  {
    jmp p[178*4];
  }
}

// waveOutMessage
extern "C" __declspec(naked) void CALLCONV __E__179__()
{
  __asm
  {
    jmp p[179*4];
  }
}

// waveOutOpen
extern "C" __declspec(naked) void CALLCONV __E__180__()
{
  __asm
  {
    jmp p[180*4];
  }
}

// waveOutPause
extern "C" __declspec(naked) void CALLCONV __E__181__()
{
  __asm
  {
    jmp p[181*4];
  }
}

// waveOutPrepareHeader
extern "C" __declspec(naked) void CALLCONV __E__182__()
{
  __asm
  {
    jmp p[182*4];
  }
}

// waveOutReset
extern "C" __declspec(naked) void CALLCONV __E__183__()
{
  __asm
  {
    jmp p[183*4];
  }
}

// waveOutRestart
extern "C" __declspec(naked) void CALLCONV __E__184__()
{
  __asm
  {
    jmp p[184*4];
  }
}

// waveOutSetPitch
extern "C" __declspec(naked) void CALLCONV __E__185__()
{
  __asm
  {
    jmp p[185*4];
  }
}

// waveOutSetPlaybackRate
extern "C" __declspec(naked) void CALLCONV __E__186__()
{
  __asm
  {
    jmp p[186*4];
  }
}

// waveOutSetVolume
extern "C" __declspec(naked) void CALLCONV __E__187__()
{
  __asm
  {
    jmp p[187*4];
  }
}

// waveOutUnprepareHeader
extern "C" __declspec(naked) void CALLCONV __E__188__()
{
  __asm
  {
    jmp p[188*4];
  }
}

// waveOutWrite
extern "C" __declspec(naked) void CALLCONV __E__189__()
{
  __asm
  {
    jmp p[189*4];
  }
}

// wid32Message
extern "C" __declspec(naked) void CALLCONV __E__190__()
{
  __asm
  {
    jmp p[190*4];
  }
}

// wod32Message
extern "C" __declspec(naked) void CALLCONV __E__191__()
{
  __asm
  {
    jmp p[191*4];
  }
}

// ___XXX___193
extern "C" __declspec(naked) void CALLCONV __E__192__()
{
  __asm
  {
    jmp p[192*4];
  }
}

